// ==UserScript==
// @name         5ch マウスジェスチャ + サイン付き
// @namespace    http://tampermonkey.net/
// @version      1.2
// @description  右ドラッグで最下部ジャンプ、上ドラッグで新着レス取得（視覚サイン付き）
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    let rightClickStartY = null;
    let isRightClicking = false;
    const dragThreshold = 100; // ｎpx以上ドラッグでフォーム表示

    document.addEventListener('mousedown', (e) => {
        if (e.button === 2) {
            rightClickStartY = e.clientY;
            isRightClicking = true;
        }
    });

    document.addEventListener('mouseup', (e) => {
        if (e.button === 2) {
            reset();
        }
    });

    document.addEventListener('mousemove', (e) => {
        if (!isRightClicking || rightClickStartY === null) return;

        const deltaY = e.clientY - rightClickStartY;

        if (deltaY > dragThreshold) {
            // ▼ 下ドラッグ → 最後の postid にジャンプ
            const posts = document.querySelectorAll('.postid');
            if (posts.length > 0) {
                const lastPost = posts[posts.length - 1];
                lastPost.scrollIntoView({ behavior: 'smooth', block: 'center' });
                showToast("最新レスにジャンプ");
            }
            reset();
        } else if (deltaY < -dragThreshold) {
            // ▲ 上ドラッグ → 新着取得関数呼び出し
            if (typeof window.check5chNewPosts === 'function') {
                window.check5chNewPosts();
                showToast("新着レス取得");
            } else {
                console.warn('check5chNewPosts 関数が見つかりません');
                showToast("⚠️ 自動更新スクリプト未読み込み");
            }
            reset();
        }
    });

    function reset() {
        rightClickStartY = null;
        isRightClicking = false;
    }

    function showToast(message) {
        const toast = document.createElement('div');
        toast.textContent = message;
        Object.assign(toast.style, {
            position: 'fixed',
            top: '20px',
            left: '50%',
            transform: 'translateX(-50%)',
            padding: '10px 16px',
            backgroundColor: 'rgba(0, 0, 0, 0.8)',
            color: '#fff',
            borderRadius: '5px',
            fontSize: '16px',
            zIndex: 99999,
            opacity: 0,
            transition: 'opacity 0.4s ease',
            pointerEvents: 'none'
        });

        document.body.appendChild(toast);
        requestAnimationFrame(() => {
            toast.style.opacity = '1';
        });

        setTimeout(() => {
            toast.style.opacity = '0';
            setTimeout(() => {
                document.body.removeChild(toast);
            }, 500);
        }, 1500);
    }
})();
